rm(list=ls())
library(cmdstanr)
library(bayesplot)
library(posterior)
library(mcmcplots)
library(magrittr)
library(multipanelfigure)
library(data.table)
library(tidylog)
library(tidyverse)

setwd("")


#The time it took five students to complete a task was (in minutes):
# 2.3, 1.2, 3.1, 2.7, 2.2

#We want to estimate the mean time, and the standard error of the mean (standard deviation of posterior distribution of the mean).
# Step 1: Specify the likelihood
# y[i] are the observed times of each of the students
# μ is the mean time and sd^2 is the variance of the time (both are unknown – to be estimated)
#Step 2: Specify prior distributions for all unknown parameters
#We will use non-informative (“flat”) priors for the parameters
#Note that the mean of a Normal distribution can take any value, but the variance and standard deviation have to be positive



data <- list(
  n = 5,
  x = c(2.3, 1.2, 3.1, 2.7, 2.2)
  )

example2 <- cmdstan_model("STAN/example2.stan")
# compile=TRUE by default

example2_fit <- example2$sample(data=data,
                                      iter_warmup=1000,
                                      iter_sampling=1000,
                                      chains = 2)
example2_fit$summary()

post_draws <- example2_fit$draws() # this is how you store the chain from Stan
#figure2 <- multi_panel_figure(columns = 3, rows = 3, panel_label_type = "upper-roman")
figure1 <- multi_panel_figure(columns = 4, rows = 4, panel_label_type = "upper-roman")
figure1 %<>%
  fill_panel(mcmc_trace(post_draws,pars='mu'), column = 1:2, row = 1) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars='mu'), column = 1:2, row = 2) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='mu'), column = 3:4, row = 1:2) %>%
  fill_panel(mcmc_trace(post_draws,pars='sigma'), column = 1:2, row = 3) %<>%
  fill_panel(mcmc_dens_overlay(post_draws,pars='sigma'), column = 1:2, row = 4) %<>%
  fill_panel(mcmc_acf_bar(post_draws,pars='sigma'), column = 3:4, row = 3:4)
figure1
